/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.unique.NightTerrorAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Nightmare
extends AbstractCard {
    public static final String ID = "Night Terror";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Night Terror");
    public static final String NAME = Nightmare.cardStrings.NAME;
    public static final String DESCRIPTION = Nightmare.cardStrings.DESCRIPTION;
    public static final String[] EXTENDED_DESCRIPTION = Nightmare.cardStrings.EXTENDED_DESCRIPTION;
    private static final int COST = 3;
    private static final int CARD_AMT = 3;
    private static final int POOL = 1;

    public Nightmare() {
        super(ID, NAME, null, "green/skill/nightmare", 3, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.NONE, 1);
        this.baseMagicNumber = 3;
        this.magicNumber = 3;
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (p.hasPower(ID)) {
            // empty if block
        }
        AbstractDungeon.actionManager.addToBottom(new NightTerrorAction(p, p, this.magicNumber));
    }

    @Override
    public AbstractCard makeCopy() {
        return new Nightmare();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeBaseCost(2);
            this.upgradeMagicNumber(1);
        }
    }
}

